<?php
	require 'connection.php';

	if(empty($_GET['league']))
		$_GET['league'] = 1;

	if(empty($_GET['division']))
		$_GET['division'] = 1;

	// GET PLAYER
	$getPlayer = $db->query("SELECT *, TIMESTAMPDIFF(YEAR, age, CURDATE()) AS age
		FROM player
		WHERE id = '".$_GET['id']."'")
	or SQLError();

	$Player = $getPlayer->fetch_array(MYSQLI_ASSOC);

	// GET PLAYER OVERALL STATS
	$getPlayer = $db->query("SELECT sum(`PTS`)/count(*) as PPG, sum(`REB`)/count(*) as RPG, sum(`AST`)/count(*) as APG, sum(`STL`)/count(*) as STLPG,
sum(`BLK`)/count(*) as BPG,
sum(`TO`)/count(*) as TPG
FROM `game_stats`
WHERE id_player = '".$_GET['id']."'")
	or SQLError();

	$PlayerOverall = $getPlayer->fetch_array(MYSQLI_ASSOC);

	// Get latest Season for player
	$getLatestSeason = $db->query("SELECT * FROM season WHERE id = (SELECT MAX(id_season) as latest_season FROM `team` t JOIN team_player tp ON t.id=tp.id_team WHERE tp.id_player=$_GET[id] LIMIT 1)")->fetch_assoc();
	$latestSeason = $getLatestSeason['name'];
	$latestSeasonId = $getLatestSeason['id'];

	// Get lastest season stats
	$getLatestStats = $db->query("SELECT sum(`PTS`)/count(*) as PPG, sum(`REB`)/count(*) as RPG, sum(`AST`)/count(*) as APG, sum(`STL`)/count(*) as STLPG,
sum(`BLK`)/count(*) as BPG,
sum(`TO`)/count(*) as TPG FROM week w JOIN game g ON w.id=g.id_week JOIN game_stats gs ON g.id = gs.id_game WHERE gs.id_player = $Player[id] AND w.id_season=$latestSeasonId");

	$latestStats = $getLatestStats->fetch_assoc();

	// GET PLAYER STATS

	$getStats = $db->query("SELECT s.name as season, t.id as id_team, t.name as team, count(*) as GP, sum(`PTS`) as PTS, SUM(`FGM`) as FGM, SUM(`FGA`) as FGA, SUM(`3PM`) as 3PM, SUM(`3PA`) as 3PA, SUM(`FTM`) as FTM, SUM(`FTA`) as FTA, SUM(`REB`) as REB, SUM(`AST`) as AST, SUM(`STL`) as STL, SUM(`BLK`) as BLK, SUM(`TO`) as `TO`, SUM(`FT`) as FT
		FROM `game_stats` gs
		LEFT JOIN game g
		ON g.id = gs.id_game
		LEFT JOIN week w
		ON w.id = g.id_week
		LEFT JOIN season s
		ON s.id = w.id_season
		LEFT JOIN team_player tp
		ON tp.id_player = gs.id_player
		LEFT JOIN team t
		ON t.id = tp.id_team
		WHERE gs.id_player = '".$_GET['id']."'
		AND t.id_season = w.id_season
		AND s.id_league = '".$_GET['league']."'
        AND s.id_division = '".$_GET['division']."'
		GROUP BY w.id_season")
	or SQLError();

	while($Stats = $getStats->fetch_array(MYSQLI_ASSOC)) {
            $StatsArray[] = $Stats;
        }

$page_title = $Player['name'] . ' Profile, Stats, Photos';
include 'template/header.php';
include 'profile_header.php';
?>
        <tr><td><hr /></td></tr>
		<tr><td>
            <p >

            <span class="red-bg">Player Profile</span> | <a href="profilelog.php?id=<?php echo $_GET['id']?>"><span class="red-bg">Game Log</span></a> | <a href="#"><span class="red-bg">Awards</a></span> | <a href="#"><span class="red-bg">Personal Records</a></span> | <a href="#"><span class="red-bg">Photos</a></span>
            </p>



<form name="frmSeasonDivisionDropDown" action="<?php echo $PHP_SELF?>">
<input type="hidden" name="id" value="<?php echo $_GET['id']?>" />
            <div>
            <label for="league"><b><u><span style="font-size: 125%;">League:</b></u></label></span>
            <select id="league" name="league" onchange="this.form.submit()">
            <option value="1" <?php if($_GET['league'] == 1) echo 'selected="selected"'; ?>>Men</option>
            <option value="2" <?php if($_GET['league'] == 2) echo 'selected="selected"'; ?>>Women</option>
            <option value="3" <?php if($_GET['league'] == 3) echo 'selected="selected"'; ?>>Co-ed</option>
            </select>
            </div>
            <div>
            <label for="division"><b><u><span style="font-size: 125%;"> Division:</b></u></label></span>
            <select id="division" name="division" onchange="this.form.submit()">
            <option value="1" <?php if($_GET['division'] == 1) echo 'selected="selected"'; ?>>Competitive</option>
            <option value="2" <?php if($_GET['division'] == 2) echo 'selected="selected"'; ?>>Recreation</option>
            </select>
            </div>
		</form>

            <?php
			if ( empty($StatsArray))
			{
				echo '<div style="padding:40px">No Stats Found for this League/Division</div>';
			}
			else
			{
				?>
                    <table>
                    <thead>
                    <tr>
                        <th colspan="17" style="font-weight:900; text-align:center" class="red-bg">
                            Stats
                        </th>
                    </tr>
                    <tr>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">SEASON</td>
			            <td style="color:white; background-color:black;font-weight:900 text-align:center">TEAM</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">GP</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">FGM-FGA</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">FG%</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">3PM-3PA</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">3P%</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">FTM-FTA</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">FT%</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">RPG</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">APG</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">SPG</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">BPG</td>
						<td style="color:white; background-color:black;font-weight:900 text-align:center">TPG</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">FPG</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center">PPG</td>
                    </tr>
                    </thead>

                    <?php
					foreach($StatsArray as $Stats)
					{
						?>
                    <tr class="tablerow<?php echo ($i++%2==0) ?0:1?>">
                        <td><?php echo $Stats['season']?></td>
                        <td>
                        <a href="team.php?id=<?php echo $Stats['id_team']?>"><?php echo $Stats['team']?></a>
                        </td>


                                <td style="text-align:center;"><?php echo $Stats['GP']?></td>
                                <td style="text-align:center;"><?php echo round($Stats['FGM']/$Stats['GP'],1)?>-<?php echo round($Stats['FGA']/$Stats['GP'],1)?></td>
						        <td style="text-align:center;">
						        <?php echo round(@(($Stats['FGM']/$Stats['GP']) / ($Stats['FGA']/$Stats['GP']))  * 100,1)?>%
						        </td>
						        <td style="text-align:center;"><?php echo round($Stats['3PM']/$Stats['GP'],1)?>-<?php echo round($Stats['3PA']/$Stats['GP'],1)?></td>
						        <td style="text-align:center;">
						        <?php echo round(@(($Stats['3PM']/$Stats['GP']) / ($Stats['3PA']/$Stats['GP']))  * 100,1)?>%
						        </td>
						        <td style="text-align:center;"><?php echo round($Stats['FTM']/$Stats['GP'],1)?>-<?php echo round($Stats['FTA']/$Stats['GP'],1)?></td>
						        <td style="text-align:center;">
						        <?php echo round( @(($Stats['FTM']/$Stats['GP']) / ($Stats['FTA']/$Stats['GP']))  * 100,1)?>%
						        </td>
                                <td style="text-align:center;"><?php echo round($Stats['REB']/$Stats['GP'],1)?></td>
                                <td style="text-align:center;"><?php echo round($Stats['AST']/$Stats['GP'],1)?></td>
                                <td style="text-align:center;"><?php echo round($Stats['STL']/$Stats['GP'],1)?></td>
                                <td style="text-align:center;"><?php echo round($Stats['BLK']/$Stats['GP'],1)?></td>
						        <td style="text-align:center;"><?php echo round($Stats['TO']/$Stats['GP'],1)?></td>
                                <td style="text-align:center;"><?php echo round($Stats['FT']/$Stats['GP'],1)?></td>
                                <td style="text-align:center;"><?php echo round($Stats['PTS']/$Stats['GP'],1)?></td>

                            <?php
								$TotalGP = $TotalFGM = $TotalFGA = $Total3PM = $Total3PA = $TotalFTM = $TotalFTA =
								$TotalRPG = $TotalAPG = $TotalSPG = $TotalBPG = $TotalTPG = $TotalFPG = $TotalPPG = '';

								$TotalGP += $Stats['GP'];
								$TotalFGM += $Stats['FGM'];
								$TotalFGA += $Stats['FGA'];
								$Total3PM += $Stats['3PM'];
								$Total3PA += $Stats['3PA'];
								$TotalFTM += $Stats['FTM'];
								$TotalFTA += $Stats['FTA'];
								$TotalRPG += $Stats['REB'];
								$TotalAPG += $Stats['AST'];
								$TotalSPG += $Stats['STL'];
								$TotalBPG += $Stats['BLK'];
								$TotalTPG += $Stats['TO'];
								$TotalFPG += $Stats['FT'];
								$TotalPPG += $Stats['PTS'];

							?>
                    </tr>
                    <?php
					}
					?>

                    <tr>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center" colspan="2">TOTALS</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo $TotalGP?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalFGM/$TotalGP),1)?>-<?php echo round($TotalFGA/$TotalGP,1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalFGM/$TotalFGA)*100,1)?>%</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($Total3PM/$TotalGP),1)?>-<?php echo round($Total3PA/$TotalGP,1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($Total3PM/$Total3PA)*100,1)?>%</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalFTM/$TotalGP),1)?>-<?php echo round($TotalFTA/$TotalGP,1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalFTM/$TotalFTA)*100,1)?>%</td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalRPG/$TotalGP),1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalAPG/$TotalGP),1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalSPG/$TotalGP),1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalBPG/$TotalGP),1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalTPG/$TotalGP),1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalFPG/$TotalGP),1)?></td>
                        <td style="color:white; background-color:black;font-weight:900 text-align:center"><?php echo round(@($TotalPPG/$TotalGP),1)?></td>
                    </tr>
                    </table>


        </td></tr>
        </table>
        <?php
			}
			?>
<?php
include 'template/footer.php';
?>
